#ifndef MARS_MSigmabarParam
#define MARS_MSigmabarParam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MSigmabarParam : public MParContainer
{
private:
  Double_t fSigmabarMin;
  Double_t fSigmabarMax;
  Double_t fMjdMin;
  Double_t fMjdMax;
  Double_t fThetaMin;
  Double_t fThetaMax;
  Int_t    fRunNumber;

public:
  
  MSigmabarParam(const char *name=NULL, const char *title=NULL);
  ~MSigmabarParam();
  
  //  void Print(Option_t *) const;

  void SetRunNumber(Int_t r);
  
  void SetParams(Int_t r, Double_t si, Double_t sx, Double_t ti, Double_t tx, Double_t mi=0, Double_t mx=0);

  Double_t GetSigmabarMin() const { return fSigmabarMin; }
  Double_t GetSigmabarMax() const { return fSigmabarMax; }
  Double_t GetThetaMin() const { return fThetaMin; }
  Double_t GetThetaMax() const { return fThetaMax; }

  void Print();
      
  ClassDef(MSigmabarParam, 1)  // Storage container for characterizing a distribution of events in the Sigmabar-Theta plane

};

#endif

