#ifndef MARS_MSigmabarCalc
#define MARS_MSigmabarCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MGeomCam
#include "MGeomCam.h"
#endif

#ifndef MARS_MMcEvt
#include "MMcEvt.hxx"
#endif

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif

#ifndef MARS_MSigmabar
#include "MSigmabar.h"
#endif

#ifndef MARS_MSigmabarParam
#include "MSigmabarParam.h"
#endif

#ifndef MARS_MRawRunHeader
#include "MRawRunHeader.h"
#endif

class MSigmabarCalc : public MTask
{
private:
    MMcEvt         *fMcEvt;
    MCerPhotEvt    *fEvt;
    MGeomCam       *fCam;
    MPedestalCam   *fPed;
    MRawRunHeader  *fRun;
    MSigmabar      *fSig;
    MSigmabarParam *fSigParam;

    Double_t fSigmabarMin; // Parametrization
    Double_t fSigmabarMax;
    Double_t fThetaMin;
    Double_t fThetaMax;

    void Reset();

public:
    MSigmabarCalc(const char *name=NULL, const char *title=NULL);
    ~MSigmabarCalc();

    Bool_t PreProcess(MParList *pList);
    Bool_t ReInit(MParList *pList);
    Bool_t Process();

    ClassDef(MSigmabarCalc, 0) // task for calculating sigmabar
}; 

#endif



