#ifndef MARS_MCT1SupercutsCalc
#define MARS_MCT1SupercutsCalc

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MParList;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MCerPhotEvt;
class MGeomCam;
class MHadronness;
class MHMatrix;


class MCT1SupercutsCalc : public MTask
{
private:
    MHillas     *fHil;
    MHillasSrc  *fHilSrc;
    MMcEvt      *fMcEvt;
    MHadronness *fHadronness;     //! output container for hadronness

    TString     fHadronnessName;  // name of container to store hadronness
    TString     fHilName;
    TString     fHilSrcName;

    Double_t    fMm2Deg;

    Int_t     fMap[8];
    MHMatrix *fMatrix;

    //---------------------------------
    // cut parameters
    TArrayD fLengthUp;
    TArrayD fLengthLo;
    TArrayD fWidthUp;
    TArrayD fWidthLo;
    TArrayD fDistUp;
    TArrayD fDistLo;
    TArrayD fAsymUp;
    TArrayD fAsymLo;
    TArrayD fAlphaUp;
    //---------------------------------

    void InitParams();

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    void Set(TArrayD &a, const TArrayD &b) { if (a.GetSize()==b.GetSize()) a=b; }
    Double_t GetVal(Int_t i) const;

    Double_t CtsMCut(
#if ROOT_VERSION_CODE > ROOT_VERSION(3,05,00)
const
#endif
                     TArrayD &a, Double_t ls, Double_t ct,
                     Double_t ls2, Double_t dd2);

public:
    MCT1SupercutsCalc(const char *hilname="MHillas",
                      const char *hilsrcname="MHillasSrc",
                      const char *name=NULL, const char *title=NULL);

    void SetParams(Double_t *par);
    void GetParams(Double_t *par);

    void SetHadronnessName(const TString name) { fHadronnessName = name; }
    TString GetHadronnessName() const { return fHadronnessName; }

    void InitMapping(MHMatrix *mat);
    void StopMapping() { InitMapping(NULL); }

    void SetLengthUp(const TArrayD &d) { Set(fLengthUp, d); }
    void SetLengthLo(const TArrayD &d) { Set(fLengthLo, d); }
    void SetWidthUp (const TArrayD &d) { Set(fWidthUp,  d); }
    void SetWidthLo (const TArrayD &d) { Set(fWidthLo,  d); }
    void SetDistUp  (const TArrayD &d) { Set(fDistUp,   d); }
    void SetDistLo  (const TArrayD &d) { Set(fDistLo,   d); }
    void SetAsymUp  (const TArrayD &d) { Set(fAsymUp,   d); }
    void SetAsymLo  (const TArrayD &d) { Set(fAsymLo,   d); }
    void SetAlphaUp (const TArrayD &d) { Set(fAlphaUp,  d); }

    const TArrayD &GetLengthUp() const { return fLengthUp; }
    const TArrayD &GetLengthLo() const { return fLengthLo; }
    const TArrayD &GetWidthUp() const  { return fWidthUp; }
    const TArrayD &GetWithLo() const   { return fWidthLo; }
    const TArrayD &GetDistUp() const   { return fDistUp; }
    const TArrayD &GetDistLo() const   { return fDistLo; }
    const TArrayD &GetAsymUp() const   { return fAsymUp; }
    const TArrayD &GetAsymLo() const   { return fAsymLo; }
    const TArrayD &GetAlphaUp() const  { return fAlphaUp; }

    ClassDef(MCT1SupercutsCalc, 0) // A class to evaluate the Supercuts
};

#endif








