#ifndef MARS_MMinuitInterface
#define MARS_MMinuitInterface

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif



class MMinuitInterface : public MTask
{
private:

  UInt_t   fNpar;
  Double_t fMin,   fEdm,   fErrdef;
  Int_t    fNpari, fNparx, fIstat;
  Int_t    fErrMinimize;


public:
  MMinuitInterface(const char *name=NULL, const char *title=NULL);
  ~MMinuitInterface();

Bool_t MMinuitInterface::CallMinuit( 
              void (*fcn)(Int_t &, Double_t *, Double_t &, Double_t *, Int_t),
              UInt_t npar, char name[80][100],
              Double_t vinit[80], Double_t step[80],
              Double_t limlo[80], Double_t limup[80], Int_t fix[80],
              TObject *fObjectFit, TString method, Bool_t nulloutput);

  ClassDef(MMinuitInterface, 1) // Class for interfacing with Minuit
};

#endif






























