#ifndef MARS_MMcTriggerLvl2
#define MARS_MMcTriggerLvl2

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MMcTrig;

class MMcEvt;

class MGeomCamMagic;

class MGeomCam;
class MGeomPix;

class MMcTriggerLvl2 : public MParContainer
{

 private:

  Int_t fPixels[36][19];  // Array with flag for triggered pixels. 1st idx:pixels in trigger cell; 2nd idx:trigger cell number  

  Int_t fFiredPixel[397]; // Array with flag for triggered pixel. idx: pixel id

  static const Int_t gsPixelsInCell[36][19];
  static const Int_t gsPixelsInLut[3][12];

  Int_t fLutPseudoSize;  // number of compact pixels in one lut
  Int_t fPseudoSize;  // Multiplicity of the cluster identified by the L2T 
  Int_t fSizeBiggerCell; // Number of fired pixel in bigger cell

  Int_t fCompactNN;  //Number of NN pixels that define a compact pixel

  Int_t fCompactPixel[397]; //Array with flag for compact pixels

  Int_t fCluster_pix[397]; //Array with pixel in cluster

  Double_t fEnergy;  // Energy of the shower


  MMcTrig *fMcTrig;
  MGeomCam *fGeomCam;  

  Int_t CalcBiggerFiredCell();
  Int_t CalcBiggerLutPseudoSize();
  void CalcPseudoSize();
   
  void SetNewCamera(MGeomCam *geom) {fGeomCam = geom;}

 public: 

  MMcTriggerLvl2(const char* name = NULL, const char* title = NULL);
  ~MMcTriggerLvl2();  
  

  virtual void Calc();

  virtual void Print(Option_t *opt="") const;

  void SetLv1(MMcTrig *trig = NULL); 
  void SetPixelFired(Int_t pixel, Int_t fired=1);
 
  void SetCompactNN(Int_t neighpix)     {fCompactNN=neighpix;}

  Int_t GetPseudoSize() const     {return fPseudoSize;}
  Int_t GetLutPseudoSize() const  {return fLutPseudoSize;}
  Int_t GetSizeBiggerCell() const {return fSizeBiggerCell;}
  Int_t GetCompactNN() const      {return fCompactNN;}

  Int_t GetCellNumberFired(int cell);
  Int_t GetLutCompactPixel(int cell, int lut);

  void CalcCompactPixels(MGeomCam *fCam);

  void CalcEnergy(MMcEvt *fMcEvt = NULL);

  Double_t GetEnergy() const    {return fEnergy;}


  ClassDef(MMcTriggerLvl2,0) // Container for 2nd Level Trigger selection parameters
};

#endif





