#ifndef MARS_MExtractedSignalPix
#define MARS_MExtractedSignalPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MExtractedSignalPix : public MParContainer
{
private:

    Float_t fExtractedSignal;      // mean value of the extracted signal
    Float_t fExtractedSignalError; // error of the mean value of the extracted signal
    Bool_t fIsLoGainUsed;
    Byte_t fNumHiGainSaturated;
    Byte_t fNumLoGainSaturated;

    Float_t fMeanArrivalTime;
    Float_t fWidthArrivalTime;

public:

    MExtractedSignalPix(const char* name=NULL, const char* title=NULL);

    void Clear(Option_t *o="");

    Float_t GetExtractedSignal()      const   { return fExtractedSignal; }
    Float_t GetExtractedSignalError() const   { return fExtractedSignalError; }

    Float_t GetMeanArrivalTime()      const   { return fMeanArrivalTime; }
    Float_t GetWidthArrivalTime()     const   { return fWidthArrivalTime; }

    void SetExtractedSignal(Float_t sig, Float_t sigerr)   
                                        { 
					  fExtractedSignal = sig; 
					  fExtractedSignalError = sigerr; 
					}

    void SetGainSaturation(Bool_t sat, Byte_t higain, Byte_t logain) 
                                        { fIsLoGainUsed = sat; 
					  fNumHiGainSaturated = higain;  
					  fNumLoGainSaturated = logain; }

    void SetArrivalTimes(Float_t mean, Float_t width) 
                                     { fMeanArrivalTime = mean;
                                       fWidthArrivalTime  = width;
				     }

    Bool_t IsLoGainUsed()               { return fIsLoGainUsed; }

    Bool_t IsValid() const              { return fExtractedSignal >= 0 || fExtractedSignalError >= 0; }

    void PrintOut();

    ClassDef(MExtractedSignalPix, 0)	// Storage Container for Extracted Signal information of one pixel
};

#endif

