#ifndef MARS_MPedPhotPix
#define MARS_MPedPhotPix

#ifndef ROOT_TObject
#include <TObject.h>
#endif

class MPedPhotPix : public TObject
{
private:
    Float_t fMean; // [phot] mean value of pedestal (should be 0)
    Float_t fRms;  // [phot] rms of mean

public:
    MPedPhotPix();

    void Clear(Option_t *o="");

    Float_t GetMean() const { return fMean; }
    Float_t GetRms() const  { return fRms; }

    //void SetMean(Float_t f) { fMean = f; }
    void SetRms(Float_t f)  { fRms  = f; }
    void Set(Float_t m, Float_t r) { fMean = m; fRms = r; }

    Bool_t IsValid() const { return fRms>=0; }

    ClassDef(MPedPhotPix, 1) // Storage Container for Pedestal information of one pixel in units of photons
};

#endif

