#ifndef MARS_MArrivalTime
#define MARS_MArrivalTime

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif
#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MRawEvtData;

class MArrivalTime : public MParContainer, public MCamEvent
{
 private:
    TArrayF fData;  // Stores the arrival times

public:

    MArrivalTime(const char *name=NULL, const char *title=NULL);
    ~MArrivalTime() { }

    void   Reset();
    void   InitSize(Int_t i);
    UInt_t GetNumPixels() const { return fData.GetSize(); }

    void SetTime(const Int_t i, const Float_t time);
    
    const TArrayF &GetData() const { return fData; }

    Double_t operator[](int i) { return fData[i]; }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MArrivalTime, 0)    // class for an event containing the arrival times
};

#endif
