#ifndef MARS_MSourcePosfromStarPos
#define MARS_MSourcePosfromStarPos

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSourcePosfromStarPos                                                   //
//                                                                         //
// Task to calculate the position of the source in the camera from
//      the position of a known star in the camera
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class TList;
class MRawRunHeader;
class MGeomCam;
class MSrcPosCam;


class MSourcePosfromStarPos : public MTask
{
 private:
    const MRawRunHeader *fRun;      //!
    const MGeomCam      *fGeomCam;  //! Camera Geometry used to calculate Hillas
    MSrcPosCam    *fSrcPos;   //!

    ifstream    *fIn;             // input file
    TList       *fFileNames;      // array which contains the \0-terminated file names

    Float_t fMm2Deg;

    Int_t   fRuns;                // current number of entries in TArray
    Int_t   fSize;                // final   number of entries in TArray

    Double_t fDecStar;
    Double_t fRaStar;

    Double_t fDecSource;
    Double_t fRaSource;

    Double_t fxSource;
    Double_t fySource;
    Double_t fdxSource;
    Double_t fdySource;

    TArrayI fRunNr;
    TArrayD fThetaTel;
    TArrayD fPhiTel;
    TArrayD fdThetaTel;
    TArrayD fdPhiTel;
    TArrayD fxStar;
    TArrayD fyStar;
    TArrayD fdxStar;
    TArrayD fdyStar;

    Int_t  AddFile(const char *fname, Int_t dummy=-1);
    Bool_t OpenNextFile();
    void   ReadData();
    void   FixSize();

    Int_t  PreProcess(MParList *pList);
    Bool_t ReInit(MParList *pList);
    Int_t  Process();
    Int_t  PostProcess();

public:
    MSourcePosfromStarPos(const char *name=NULL, const char *title=NULL);
    ~MSourcePosfromStarPos();

    void SetSourceAndStarPosition(Double_t decSource, Double_t raSource,
				  Double_t decStar,   Double_t raStar);

    void SourcefromStar(Double_t &, Double_t &, Double_t &,
      Double_t &, Double_t &, Double_t &, Double_t &, Double_t &, Double_t &,
      Double_t &, Double_t &, Double_t &, Double_t &, Double_t &, Double_t & );

    ClassDef(MSourcePosfromStarPos, 0) // Task to calculate the source position from a star position
};

#endif








