/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@astro.uni-wuerzburg.de>
!   Author(s): Harald Kornmayer 1/2001
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */


/////////////////////////////////////////////////////////////////////////////
//
// MCerPhotPix
//
// Storage container for the signal in a pixel in number of photons.
//
// NOTE: This container is NOT ment for I/O. Write it to a file on your
//       own risk!
//
// fIsSaturated: boolean variable set to kTRUE whenever one or more of
//               the low gain FADC slices of the pixel is in saturation.
//
// Version 2:
// ----------
//  - added fIsSaturated
//
// Version 4:
// ----------
//  - added fIsHGSaturated
//
////////////////////////////////////////////////////////////////////////////
#include "MCerPhotPix.h"

#include "MLog.h"

ClassImp(MCerPhotPix);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. The pixel is assumed as used and not a core pixel.
// NT 29/04/2003: A pixel is considered used when fRing > 0.
//
MCerPhotPix::MCerPhotPix(Int_t pix, Float_t phot, Float_t errphot) :
  fPixId(pix), fRing(1), fIsCore(kFALSE), fPhot(phot), fErrPhot(errphot), fIsSaturated(kFALSE), fIsHGSaturated(kFALSE)
{
} 

// --------------------------------------------------------------------------
//
//  Print information to gLog.
//
void MCerPhotPix::Print(Option_t *) const
{ 
    gLog << GetDescriptor() <<" Pixel: "<< fPixId;
    gLog << (fRing>0?"   Used ":" Unused ");
    gLog << (fIsCore?" Core ":"      ");
    gLog << "High gain " << (fIsHGSaturated?"   ":"not") << " saturated";
    gLog << (fIsSaturated?"   ":"Not") << " saturated";
    gLog << " Nphot= " << fPhot << " Error(Nphot)=" << fErrPhot << endl;
}
