#ifndef MARS_MPedCalcPedRun
#define MARS_MPedCalcPedRun

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MRawEvtData;
class MPedestalCam;
class MGeomCam;
class MPedCalcPedRun : public MTask
{

  Byte_t fNumHiGainSamples;
  UInt_t fNumSamplesTot;
  
  MRawEvtData  *fRawEvt;     // raw event data (time slices)
  MPedestalCam *fPedestals;  // Pedestals of all pixels in the camera
  MGeomCam     *fGeom;       // Camera geometry
  
  TArrayF fSumx;         // sum of values
  TArrayF fSumx2;        // sum of squared values
  TArrayF fAreaSumx;     // averaged sum of values per area idx
  TArrayF fAreaSumx2;    // averaged sum of squared values per area idx
  TArrayI fAreaValid;    // number of valid pixel with area idx  
  TArrayF fSectorSumx;   // averaged sum of values per sector 
  TArrayF fSectorSumx2;  // averaged sum of squared values per sector
  TArrayI fSectorValid;  // number of valid pixel with sector idx  
  
  Int_t  PreProcess ( MParList *pList );
  Bool_t ReInit     ( MParList *pList );
  Int_t  Process    ();
  Int_t  PostProcess();
  
public:

  MPedCalcPedRun(const char *name=NULL, const char *title=NULL);
  
  void Clear(const Option_t *o="");
  void SetNumHiGainSamples(const Byte_t n)      { fNumHiGainSamples = n;   }
  
  ClassDef(MPedCalcPedRun, 0)   // Task to calculate pedestals from pedestal runs raw data
};

#endif
