#ifndef MARS_MBlindPixelsCalc2
#define MARS_MBlindPixelsCalc2

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MGeomCam;
class MCerPhotEvt;
class MBlindPixels;

class MPedPhotCam;

class MBlindPixelsCalc2 : public MTask
{
private:
    MCerPhotEvt  *fEvt;     //!
    MBlindPixels *fPixels;  //!
    MGeomCam     *fGeomCam; //!
    MPedPhotCam  *fPed;     //!

    TArrayS fPixelsIdx;  // Pixel Indices for blind pixels, which are entered by the user.
    Byte_t fFlags;       // flag for the method which is used

    enum
    {
        kUseInterpolation = 1,
        kUseCentralPixel  = 2,
	kCheckPedestalRms = 3,
        kUseBlindPixels   = 4
    };

 
    static Double_t Pow2(Double_t x) { return x*x; }

    void Interpolate() const;
    void InterpolatePedestals() const;
    void Unmap() const;
    Bool_t CheckPedestalRms() ;


    void PrintSkipped(int i, const char *str) const;

    void StreamPrimitive(ofstream &out) const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    TArrayL  fErrors;     

public:

    MBlindPixelsCalc2(const char *name=NULL, const char *title=NULL);

    void SetUseInterpolation(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseInterpolation) : CLRBIT(fFlags, kUseInterpolation);
    }
    void SetUseCentralPixel(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseCentralPixel) : CLRBIT(fFlags, kUseCentralPixel);
    }
    void SetCheckPedestalRms(Bool_t b=kTRUE) 
   {
        b ? SETBIT(fFlags,kCheckPedestalRms) : CLRBIT(fFlags, kCheckPedestalRms);
    }
    void SetUseBlindPixels(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseBlindPixels) : CLRBIT(fFlags, kUseBlindPixels);
    }

    void SetPixelIndices(const TArrayS &pix) { fPixelsIdx = pix; }

    virtual Bool_t ReInit(MParList *pList);

    ClassDef(MBlindPixelsCalc2, 1) // (temp!)task to deal with hot spots (star, broken pixels, etc) 
}; 

#endif







