#include "MCerPhotPix.h"

#include "MLog.h"

ClassImp(MCerPhotPix)

MCerPhotPix::MCerPhotPix(Int_t pix, Float_t phot, Float_t errphot ) :
    fPixId(pix), fIsUsed(kTRUE), fIsCore(kFALSE), fPhot(phot), fErrPhot(errphot)
{
} 

void MCerPhotPix::SetPixelContent(Int_t pix, Float_t phot, Float_t errphot)
{
  fPixId    = pix ; 
  fIsUsed   = kTRUE ; 
  fIsUsed   = kFALSE ; 
  fPhot     = phot ; 
  fErrPhot  = errphot ; 
}

void MCerPhotPix::Print(Option_t *)
{ 
  //   information about a pixel
    gLog << "MCerPhotPix: Pixel: "<< fPixId ;

    gLog << (fIsUsed?"    Used ":"  Unused ");

    gLog << (fIsCore?"  Core  ":"        ");

    gLog << "  Nphot= " << fPhot
        << "  Error(Nphot) = " << fErrPhot
        << endl ;
}

