#ifndef MCERPHOTPIX_H
#define MCERPHOTPIX_H

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif

class MCerPhotPix : public TObject
{
 private:
  
  Int_t    fPixId     ;  // the pixel Id
  Bool_t   fIsUsed    ;  // the pixel is used for calculations --> kTRUE
  Bool_t   fIsCore    ;  // the pixel is a Core pixel          --> kTRUE
  Float_t  fPhot      ;  // The number of Cerenkov photons
  Float_t  fErrPhot   ;  // the error of fPhot
 
 public:
  
  MCerPhotPix(Int_t pix = -1, Float_t phot=0. , Float_t errphot=0.) ;

  void Print(Option_t *opt = NULL) ;
             
  Int_t   GetPixId() const      { return fPixId ;    }
  Float_t GetNumPhotons() const { return fPhot ;     }
  Float_t GetErrorPhot() const  { return fErrPhot ;  }

  void SetPixelContent(Int_t pix, Float_t phot, Float_t errphot);

  Bool_t IsPixelUsed() const    { return fIsUsed ;   }
  void   SetPixelUnused()       { fIsUsed = kFALSE ; }
  void   SetPixelUsed()         { fIsUsed = kTRUE ;  }

  void   SetCorePixel()         { fIsCore = kTRUE ;  }
  Bool_t IsCorePixel() const    { return fIsCore ;   }

  void SetNumPhotons(Float_t f) { fPhot    = f; }
  void SetErrorPhot(Float_t f)  { fErrPhot = f; }
  
  ClassDef(MCerPhotPix, 1)  // class containing information about the Cerenkov Photons in a pixel
} ; 

#endif


