#ifndef MARS_MBadPixelsPix
#define MARS_MBadPixelsPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MBadPixelsPix : public MParContainer
{
private:
    TArrayI fInfo;

public:
    MBadPixelsPix(const char* name=NULL, const char* title=NULL);

    enum UnsuitableType_t {
        kUnsuitableRun = BIT(1),
        kUnsuitableEvt = BIT(2),
        kUnreliableRun = BIT(3)
    };

    static const Int_t fgRunMask; // All types which are not event wise determined

    // All types are initialized to normal behaviour
    enum UncalibratedType_t {
      kHiGainNotFitted          = BIT(1),
      kLoGainNotFitted          = BIT(2), 
      kRelTimeNotFitted         = BIT(3),
      kHiGainOscillating        = BIT(4),
      kLoGainOscillating        = BIT(5),
      kRelTimeOscillating       = BIT(6),
      kLoGainSaturation         = BIT(7),
      kChargeIsPedestal         = BIT(8 ),
      kChargeErrNotValid        = BIT(9 ),
      kChargeRelErrNotValid     = BIT(10),
      kChargeSigmaNotValid      = BIT(11),
      kMeanTimeInFirstBin       = BIT(12),
      kMeanTimeInLast2Bins      = BIT(13), 
      kDeviatingNumPhes         = BIT(14),
      kDeviatingFFactor         = BIT(15),
      kConversionHiLoNotValid   = BIT(16)
    };
    
    void Reset();
    void Clear(Option_t *o="");
    void Copy(TObject &object) const
    {
        static_cast<MBadPixelsPix&>(object).fInfo = fInfo;
    }

    // Setter
    void SetUnsuitable  ( UnsuitableType_t   typ ) { fInfo[0] |= typ; }
    void SetUncalibrated( UncalibratedType_t typ ) { fInfo[1] |= typ; }

    // Getter
    Bool_t IsUnsuitable  ( UnsuitableType_t   typ ) const { return fInfo[0]&typ; }
    Bool_t IsUncalibrated( UncalibratedType_t typ ) const { return fInfo[1]&typ; }

    Bool_t IsOK()  const { return fInfo[0]==0; }
    Bool_t IsBad() const { return fInfo[0]!=0; }

    Bool_t IsLoGainBad() const { return IsUnsuitable  (kUnsuitableRun      )
				     || IsUncalibrated(kLoGainSaturation   ) 
				     || IsUncalibrated(kConversionHiLoNotValid) 
				     || IsUncalibrated(kLoGainOscillating  ) ; }
    Bool_t IsHiGainBad() const { return IsUnsuitable  (kUnsuitableRun      )
  				     || IsUncalibrated(kHiGainOscillating  ) ; }

    void Merge(const MBadPixelsPix &pix);

    const TArrayI &GetInfo() const { return fInfo; }

    ClassDef(MBadPixelsPix, 1)	// Storage Container for bad pixel information of a single pixel
};

#endif

