#ifndef MARS_MBadPixelsTreat
#define MARS_MBadPixelsTreat

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MPedPhotCam;
class MBadPixelsCam;

class MBadPixelsTreat : public MTask
{
private:
    MGeomCam      *fGeomCam;   //!
    MPedPhotCam   *fPedPhot;   //!
    MCerPhotEvt   *fEvt;       //!
    MBadPixelsCam *fBadPixels; //!

    Byte_t fFlags;       // flag for the method which is used
    Byte_t fNumMinNeighbors;
    TString fNamePedPhotContainer; // name of the 'MPedPhotCam' container

    enum
    {
        kUseInterpolation = 1,
        kUseCentralPixel  = 2,
        kProcessRMS       = 3,
        kHardTreatment    = 4
    };

    static Double_t Pow2(Double_t x) { return x*x; }

    void InterpolateSignal() const;
    void InterpolatePedestals() const;

    void   Unmap() const;
    Bool_t IsPixelBad(Int_t idx) const;

    Bool_t ReInit(MParList *pList);
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();
    Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);
    void   StreamPrimitive(ofstream &out) const;

public:
    MBadPixelsTreat(const char *name=NULL, const char *title=NULL);

    void SetUseInterpolation(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseInterpolation) : CLRBIT(fFlags, kUseInterpolation);
    }
    void SetUseCentralPixel(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseCentralPixel) : CLRBIT(fFlags, kUseCentralPixel);
    }
    void SetProcessRMS(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kProcessRMS) : CLRBIT(fFlags, kProcessRMS);
    }
    void SetHardTreatment(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kHardTreatment) : CLRBIT(fFlags, kHardTreatment);
    }

    Bool_t IsHardTreatment() const    { return TESTBIT(fFlags, kHardTreatment); }
    Bool_t IsProcessRMS() const       { return TESTBIT(fFlags, kProcessRMS); }
    Bool_t IsUseCentralPixel() const  { return TESTBIT(fFlags, kUseCentralPixel); }
    Bool_t IsUseInterpolation() const { return TESTBIT(fFlags, kUseInterpolation); }

    void SetNumMinNeighbors(Byte_t num) { fNumMinNeighbors=num; }
    void SetNamePedPhotContainer(const char *name)    { fNamePedPhotContainer = name; }


    ClassDef(MBadPixelsTreat, 1) // Task to treat bad pixels (interpolation, unmapping)
}; 

#endif

