#ifndef MARS_MClone
#define MARS_MClone

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;

class MClone : public MTask
{
private:
    const TObject *fObject; // pointer to container which has to be cloned
    TString fObjName;       // given name to search for in the parameterlist

    TObject* fClone;        // pointer to the cloned object. deletion is handled by MClone

    void Init(const char *name, const char *title);

public:
    MClone(const char *obj,    const char *name=NULL, const char *title=NULL);
    MClone(const TObject *obj, const char *name=NULL, const char *title=NULL);
    ~MClone();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    TObject *GetClone() const { return fClone; }

    void Clear(Option_t *opt=NULL);

    ClassDef(MClone, 0) // Task to clone (duplicate) an object in memory
};
    
#endif

