#ifndef MARS_MContinue
#define MARS_MContinue

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MContinue                                                               //
//                                                                         //
// Does nothing than return kCONTINUE in the Process-fucntion              //
// (use with filters)                                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MFilter;
class MTaskList;

class MContinue : public MTask
{
private:
    MTaskList *fTaskList;  //! pointer to the present tasklist

    Bool_t PreProcess(MParList *list);
    Bool_t Process() { return kCONTINUE; }
    Bool_t PostProcess();

    enum { kIsOwner = BIT(14), kFilterIsPrivate = BIT(15) };

public:
    MContinue(const TString rule="", const char *name=NULL, const char *title=NULL);
    MContinue(MFilter *f, const char *name=NULL, const char *title=NULL);
    ~MContinue();

    void SetInverted(Bool_t i=kTRUE);
    Bool_t IsInverted() const;

    ClassDef(MContinue, 1) //Task returning kCONTINUE
};

#endif
