#ifndef MARS_MMath
#define MARS_MMath

#ifndef ROOT_TMath
#include <TMath.h>
#endif
#ifndef ROOT_TVector3
#include <TVector3.h>
#endif

namespace MMath
{
    Double_t GaussProb(Double_t x, Double_t sigma, Double_t mean=0);

    Double_t Significance(Double_t s, Double_t b);
    Double_t SignificanceSym(Double_t s, Double_t b);
    Double_t SignificanceLiMa(Double_t s, Double_t b, Double_t alpha=1);
    Double_t SignificanceLiMaSigned(Double_t s, Double_t b, Double_t alpha=1);

    void ReducePrecision(Float_t &val);

    TVector3 GetParab(const TVector3 &x, const TVector3 &y);
    Double_t InterpolParabLin(const TVector3 &vx, const TVector3 &vy, Double_t x);
    Double_t InterpolParabLog(const TVector3 &vx, const TVector3 &vy, Double_t x);
    Double_t InterpolParabCos(const TVector3 &vx, const TVector3 &vy, Double_t x);
}

#endif
