#ifndef MARS_MString
#define MARS_MString

#ifndef ROOT_TString
#include <TString.h>
#endif

#include <stdio.h>
#include <stdarg.h>

class MString : public TString
{
public:
    MString(const char *txt=0)  : TString(txt) { }
    MString(const MString &txt) : TString(txt) { }

    MString &Print(const char *fmt, va_list &ap);
    MString &Print(const char *fmt, ...);

#ifndef __CINT__
    static MString Format(const char *fmt, ...);
#endif

    void Form(const char *fmt, ...);

    ClassDef(MString, 1) // Tool to make Form() thread safe against other TStrings
};

#endif
