#ifndef MFILTERLIST_H
#define MFILTERLIST_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MFilterList                                                            //
//                                                                         //
//  List of several filters                                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef ROOT_TOrdCollection
#include <TOrdCollection.h>
#endif
#ifndef MFILTER_H
#include "MFilter.h"
#endif

class MParList;

class MFilterList : public MFilter
{
private:
    TOrdCollection fFilters;	// Container for the filters

    typedef enum { kEAnd, kEOr, kEXor, kELAnd, kELOr } FilterType_t;
    FilterType_t fFilterType;

public:
    MFilterList(const char *type="&&");
    ~MFilterList()
    {
    }
    MFilterList(MFilterList &ts);

    Bool_t AddToList(MFilter *filter);

    Bool_t IsExpressionTrue() const;

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void Print(Option_t *opt = "");

    ClassDef(MFilterList, 0)		// List to combine several filters logically
};

#endif
