#ifndef MPARCONTAINER_H
#define MPARCONTAINER_H

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// MParContainer                                                        //
//                                                                      //
// The basis for all parameter containers                               //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TObject
#include <TObject.h>
#endif
#ifndef ROOT_TString
#include <TString.h>
#endif

class ofstream;
class ifstream;

class MParContainer : public TObject
{
private:
    void Init(const char *name, const char *title)
    {
        fName = new TString;
        (*fName) = name;
        fTitle = new TString;
        (*fTitle) = title;
    }

protected:
    MLog    *fLog;         //! The general log facility for this object, initialized with the global object

    TString *fName;        //! parameter container identifier (name)
    TString *fTitle;       //! parameter container title

    Bool_t   fReadyToSave; //! should be set to true if the contents of the container is changed somehow

public:
    MParContainer(const char *name="", const char *title="") : fLog(&gLog), fReadyToSave(kFALSE) { Init(name, title); }
    MParContainer(const TString &name, const TString &title) : fLog(&gLog), fReadyToSave(kFALSE) { Init(name, title); }
    MParContainer(const MParContainer &named);
    MParContainer& operator=(const MParContainer& rhs);

    void SetLogStream(MLog *lg) { fLog = lg; }

    virtual ~MParContainer() { 
      //delete fName; delete fTitle;
    }
    virtual Int_t    Compare(TObject *obj);
    virtual void     Copy(TObject &named);
    virtual void     FillBuffer(char *&buffer);
    virtual const char  *GetName() const {return fName->Data();}
    virtual const char  *GetTitle() const {return fTitle->Data();}
    virtual ULong_t  Hash() { return fName->Hash(); }
    virtual Bool_t   IsSortable() const { return kTRUE; }
    virtual void     SetName(const char *name); // *MENU*
    virtual void     SetObject(const char *name, const char *title);
    virtual void     SetTitle(const char *title=""); // *MENU*
    virtual void     ls(Option_t *option="");
    virtual void     Print(Option_t *option="");
    virtual Int_t    Sizeof() const;

    virtual void     Reset() {};

    virtual Bool_t IsReadyToSave() { return fReadyToSave; }
    virtual void   SetReadyToSave(Bool_t flag=kTRUE) { fReadyToSave=flag; }

    virtual void AsciiRead(ifstream &fin);
    virtual void AsciiWrite(ofstream &fout) const;

    ClassDef(MParContainer, 1)  //The basis for all parameter containers
};

#endif


