#ifndef MARS_MExtractBlindPixel
#define MARS_MExtractBlindPixel

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MExtractBlindPixel                                                        //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MRawRunHeader;

class MPedestalCam;
class MExtractedSignalBlindPixel;
class MExtractBlindPixel : public MTask
{
private:

  static const UInt_t fgBlindPixelIdx;  
  static const Byte_t fgSaturationLimit;
  static const Byte_t fgFirst;
  static const Byte_t fgLast;

  MExtractedSignalBlindPixel  *fBlindPixel;   // Extracted signal of the Blind Pixel

  MRawEvtData         *fRawEvt;       // raw event data (time slices)
  MRawRunHeader       *fRunHeader;    // RunHeader information
  
  Byte_t  fFirst;
  Byte_t  fLast;
  Byte_t  fNumSamples;
  Float_t fSqrtSamples;
  Byte_t  fSaturationLimit;

  UInt_t  fBlindPixelIdx;

  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  void   StreamPrimitive(ofstream &out) const;
  
public:

  MExtractBlindPixel(const char *name=NULL, const char *title=NULL);

  // Setters
  void SetRange(const Byte_t first=fgFirst, const Byte_t last=fgLast);
  void SetSaturationLimit(const Byte_t lim=fgSaturationLimit) { fSaturationLimit = lim; }
  void SetBlindPixelIdx( const UInt_t idx=fgBlindPixelIdx  ) { fBlindPixelIdx = idx;   }  

  ClassDef(MExtractBlindPixel, 0) // Task to fill the Extracted BlindPixel Containers from raw data
};

#endif
