#ifndef MARS_MExtractedSignalBlindPixel
#define MARS_MExtractedSignalBlindPixel

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MExtractedSignalBlindPixel : public MParContainer
{
private:

  UInt_t fExtractedSignal;    // mean value of the extracted signal

  Byte_t fFirst;
  Byte_t fNumFADCSamples;
  Byte_t fNumSaturated;

public:

  MExtractedSignalBlindPixel(const char* name=NULL, const char* title=NULL);

  void Clear(Option_t *o="");
  void Print(Option_t *o="") const;
  
  // Setter
  void SetExtractedSignal(const UInt_t sig)          { fExtractedSignal = sig;  }
  void SetNumSaturated(  const Byte_t numsat)       { fNumSaturated    = numsat;  }
  void SetUsedFADCSlices( const Byte_t first, const Byte_t num);
    
    // Getter
  UInt_t GetExtractedSignal()    const { return fExtractedSignal; }

  Byte_t  GetNumFADCSamples()     const { return fNumFADCSamples;  }
  
  Bool_t IsValid() const;   

  ClassDef(MExtractedSignalBlindPixel, 0)	// Storage Container for Extracted Signal of the blind pixel
};

#endif
