#ifndef MARS_MHCalibrationRelTimeCam
#define MARS_MHCalibrationRelTimeCam

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class MHCalibrationRelTimePix;
class MHCalibrationRelTimeCam : public MH, public MCamEvent
{

private:

  static const Float_t fgTimeSliceWidth;          // Default FADC slice time width for MAGIC
  Float_t              fTimeSliceWidth;          //  FADC slice time width
  
  TObjArray  *fArray;       //-> List of MHCalibrationRelTimePix's

public:

  MHCalibrationRelTimeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationRelTimeCam();

  void Clear(Option_t *o="");
  
  MHCalibrationRelTimePix &operator[](UInt_t i);
  const MHCalibrationRelTimePix &operator[](UInt_t i) const;
  
  Bool_t SetupFill(const MParList *pList);
  Bool_t Fill(const MParContainer *par, const Stat_t w=1);
  Bool_t Finalize();

  // Setters
  void SetTimeSliceWidth(const Float_t width=fgTimeSliceWidth)  {  fTimeSliceWidth = width; }
  
  TObject *Clone(const char *) const;
  
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;
  
  ClassDef(MHCalibrationRelTimeCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

