#ifndef MARS_MHCalibrationChargeLoGainPix
#define MARS_MHCalibrationChargeLoGainPix


#ifndef MARS_MHCalibrationChargePix
#include "MHCalibrationChargePix.h"
#endif

class MHCalibrationChargeLoGainPix : public MHCalibrationChargePix
{
private:

  static const Int_t   fgChargeNbins;
  static const Axis_t  fgChargeFirst;
  static const Axis_t  fgChargeLast;  

  static const Int_t   fgAbsTimeNbins;
  static const Axis_t  fgAbsTimeFirst;
  static const Axis_t  fgAbsTimeLast;

public:

  MHCalibrationChargeLoGainPix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeLoGainPix(){}

  // Setters
  void SetChargeNbins(const Int_t  bins =fgChargeNbins)          { fChargeNbins = bins;     }
  void SetChargeFirst(const Axis_t first=fgChargeFirst)          { fChargeFirst = first;    }
  void SetChargeLast (const Axis_t last =fgChargeLast)           { fChargeLast  = last;     }
  
  void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)        { fAbsTimeNbins = bins;    }
  void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)        { fAbsTimeFirst = first;   }
  void SetAbsTimeLast (const Axis_t last =fgAbsTimeLast)         { fAbsTimeLast  = last;    }

  ClassDef(MHCalibrationChargeLoGainPix, 1)  // Histogram class for a Calibration Pixel with extracted Low Gain 
};

#endif








