#ifndef MARS_MCalibrationChargeCam
#define MARS_MCalibrationChargeCam

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

#ifndef ROOT_TArrayI
#include "TArrayI.h"
#endif

class MCalibrationChargeCam : public MCalibrationCam
{
private:
  
  Byte_t  fFlags;                    // Bit-field to hold the flags

  enum  { kFFactorMethodValid };

public:

  MCalibrationChargeCam(const char *name=NULL, const char *title=NULL);
  
  void   Clear ( Option_t *o="" );
  
  // Draws
  void   DrawPixelContent(Int_t num)   const;    

  // Getters
  Bool_t GetConversionFactorFFactor( Int_t ipx, Float_t &mean, Float_t &err, Float_t &ffactor );
  Bool_t GetPixelContent           ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  Bool_t IsFFactorMethodValid()      const;

  // Inits
  void  Init                   ( const MGeomCam &geom         );
  
  // Prints
  void   Print(Option_t *o="")         const;

  // Setters   
  void   SetFFactorMethodValid ( const Bool_t b=kTRUE );

  ClassDef(MCalibrationChargeCam, 1) // Container Charge Calibration Results Camera
};

#endif
