#ifndef MARS_MHCalibrationRelTimePix
#define MARS_MHCalibrationRelTimePix

#ifndef MARS_MHCalibrationPix
#include "MHCalibrationPix.h"
#endif

class MHCalibrationRelTimePix : public MHCalibrationPix
{

private:

  static const Int_t   fgRelTimeNbins;      //! Default for fNbins          (now set to: 900   )
  static const Axis_t  fgRelTimeFirst;      //! Default for fFirst          (now set to: -13.5 )
  static const Axis_t  fgRelTimeLast;       //! Default for fLast           (now set to:  13.5 )
  static const Float_t fgFADCSliceWidth;    //! Default for fFADCSliceWidth (now set to: 3.333)
  
  Float_t fFADCSliceWidth;                 //  Time FADC Slice Width in ns.
  
public:

  MHCalibrationRelTimePix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationRelTimePix() {}

  // Getters
  Float_t GetFADCSliceWidth() const    { return fFADCSliceWidth;  }
  
  // Setters
  void SetFADCSliceWidth( const Float_t f=fgFADCSliceWidth )  {  fFADCSliceWidth = f; }
  
  ClassDef(MHCalibrationRelTimePix, 1)     // Histogram class for Relative Time Pixel Calibration
};

#endif
