#ifndef MARS_MCameraPowerSupply
#define MARS_MCameraPowerSupply

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MCameraPowerSupply : public MParContainer
{
    friend class MReportCamera;
private:
     Float_t fVoltagePos5V;         // [V] voltage_pos5  (+5V)
     Float_t fVoltagePos12V;        // [V] voltage_pos12 (+12V)
     Float_t fVoltageNeg12V;        // [V] voltage_neg12 (-12V)
     Float_t fVoltageOptLinkPos12V; // [V] volatge_opt_link_pos12 (+12V)

     Float_t fCurrentPos5V;         // [A] current_pos5  (+5V)
     Float_t fCurrentPos12V;        // [A] current_pos12 (+12V)
     Float_t fCurrentNeg12V;        // [A] current_neg12 (-12V)
     Float_t fCurrentOptLinkPos12V; // [A] current_opt_link_pos12 (+12V)

public:
    MCameraPowerSupply()
    {
        fName  = "MCameraPowerSupply";
        fTitle = "Container storing information about the Camera power supply";
    }
    ClassDef(MCameraPowerSupply, 1) // Container storing information about the Camera power supply
};

#endif
