#ifndef MARS_MCameraRecTemp
#define MARS_MCameraRecTemp

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class MCameraRecTemp : public MParContainer
{
    friend class MReportCC;
private:
    TArrayF fRecTemp; // [deg C] receiver board temperatures

public:
    MCameraRecTemp(Int_t size=76, const char *name=NULL, const char *title=NULL);

    void SetRecTemp(Int_t i, Float_t val) { fRecTemp[i] = (Int_t)val; }
    Float_t GetRecTemp(Int_t i) const { return (*this)[i]; }
    Float_t &operator[](Int_t i) { return (Float_t&)fRecTemp[i]; }
    const Float_t &operator[](Int_t i) const { return (*const_cast<MCameraRecTemp*>(this))[i]; }

    Float_t GetMin() const;
    Float_t GetMax() const;

    void Print(Option_t *opt=NULL) const;

    ClassDef(MCameraRecTemp, 1) // Storage Container for Receiver Board Temperature
};

#endif
