/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 5/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!   Author(s): Florian Goebel 11/2005 <mailto:fgoebel@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2005
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MCameraTD (PRELIMINARY)
//
/////////////////////////////////////////////////////////////////////////////
#include "MCameraTD.h"

#include <TMath.h>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MCameraTD);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor.
//
MCameraTD::MCameraTD(Int_t size, const char *name, const char *title)
    : fTD(size)
{
    fName  = name  ? name  : "MCameraTD";
    fTitle = title ? title : "Storage container for the pixel discriminator delays";
}

// --------------------------------------------------------------------------
//
// Print the dc currents
//
void MCameraTD::Print(Option_t *) const
{
    *fLog << all << underline << GetDescriptor() << endl;
    for (int i=0; i<fTD.GetSize(); i++)
        *fLog << " " << GetDelay(i);
    *fLog << endl;
}

// --------------------------------------------------------------------------
//
// Return the minimum discriminator delays
//
Float_t MCameraTD::GetMin() const
{
    Float_t val = (UInt_t)-1;
    for (int i=0; i<fTD.GetSize(); i++)
        val = TMath::Min(val, GetDelay(i));
    return val;
}

// --------------------------------------------------------------------------
//
// Return the maximum discriminator delays
//
Float_t MCameraTD::GetMax() const
{
    Float_t val = 0;
    for (int i=0; i<fTD.GetSize(); i++)
        val = TMath::Max(val, GetDelay(i));
    return val;
}
