#ifndef MARS_MCameraTH
#define MARS_MCameraTH

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MCameraTH : public MParContainer, public MCamEvent
{
    friend class MReportCC;
private:
    TArrayS fTH; // [au] discriminator thresholds

public:
    MCameraTH(Int_t size=577, const char *name=NULL, const char *title=NULL);

    void SetThreshold(Int_t i, Float_t val) { fTH[i] = (Int_t)val; }
    Float_t GetThreshold(Int_t i) const { return (*this)[i]; }
    Float_t &operator[](Int_t i) { return (Float_t&)fTH[i]; }
    const Float_t &operator[](Int_t i) const { return (*const_cast<MCameraTH*>(this))[i]; }

    Float_t GetMin() const;
    Float_t GetMax() const;

    void Print(Option_t *opt=NULL) const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
        val = fTH[idx];
        return val>0;
    }
    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MCameraTH, 1) // Storage Container for the discriminator thresholds
};

#endif
