#ifndef MARS_MCameraTH
#define MARS_MCameraTH

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayC
#include <TArrayC.h>
#endif

class MCameraTH : public MParContainer, public MCamEvent
{
    friend class MReportCC;
private:
    TArrayC fTH; // [au] discriminator thresholds

public:
    MCameraTH(Int_t size=577, const char *name=NULL, const char *title=NULL);

    Byte_t operator[](Int_t i) { return fTH[i]; }

    Byte_t GetMin() const;
    Byte_t GetMax() const;

    void Print(Option_t *opt=NULL) const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
        if (idx>=fTH.GetSize())
            return kFALSE;

        val = fTH[idx];
        return val>0;
    }
    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MCameraTH, 1) // Storage Container for the discriminator thresholds
};

#endif
