#ifndef MARS_MDataValue
#define MARS_MDataValue

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MDataValue                                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MData
#include "MData.h"
#endif

class MDataValue : public MData
{
private:
    Double_t fValue;

public:
    MDataValue(Double_t v = 0) : fValue(v)
    {
    }

    Double_t GetValue() const { return fValue; }
    Bool_t PreProcess(const MParList *plist) { return kTRUE; }

    Bool_t IsValid() const { return kTRUE; }
    Bool_t IsReadyToSave() const { return kFALSE; }

    //void Print(Option_t *opt = "") const;
    TString GetRule() const;

    ClassDef(MDataValue, 1) // MData object corresponding to a single value
};

#endif
