#ifndef MHISTOSADC_H
#define MHISTOSADC_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class MHistosAdc : public MParContainer
{
private:
    TObjArray *fHistHi;	// List of High gain Histograms
    TObjArray *fHistLo;	// List of Low  gain Histograms

public:
     MHistosAdc(const char *name=NULL, const char *title=NULL);
    ~MHistosAdc();

    void FillAdcHistHi (Int_t iPix, Byte_t data);
    void FillAdcHistLo (Int_t iPix, Byte_t data);

    void SaveHist(char *name);

    void Print(Option_t *t = NULL);

    TH1F *GetHistHi(Int_t i)  { return (TH1F*)(fHistHi->At(i)); }
    TH1F *GetHistLo(Int_t i)  { return (TH1F*)(fHistLo->At(i)); }

    void DrawHi(Int_t i) { GetHistHi(i)->Draw(); }
    void DrawLo(Int_t i) { GetHistHi(i)->Draw(); }

/*
    TObjArray* GetHiList()
      { 
	return fHistHi ;
      }   

    TObjArray* GetLoList()
      { 
	return fHistLo ;
      } 
*/
    Int_t GetHiEntries()
      { 
	return fHistHi->GetEntries() ;
      } 

    Int_t GetLoEntries()
      { 
	return fHistLo->GetEntries() ;
      } 

      
    ClassDef(MHistosAdc, 1)	// list of Histograms with ADC spectra
};

#endif

