///////////////////////////////////////////////////////////////////////
//
// MHFadcCam
//
// This class contains a list of all ADC spektra histograms
//
///////////////////////////////////////////////////////////////////////

#include "MHFadcCam.h"

#include <TH1.h>

ClassImp(MHFadcCam)

MHFadcCam::MHFadcCam (const char *name, const char *title)
{
    //
    //  default constructor
    //  creates an a list of histograms for all pixels and both gain channels
    //

    //
    //   set the name and title of this object
    //
    
    *fName  = name  ? name  : "MHFadcCam" ;
    *fTitle = title ? title : "Container for ADC spectra histograms" ;

    //
    //   loop over all Pixels and create two histograms
    //   one for the Low and one for the High gain
    //   connect all the histogram with the container fHist
    //
    fArray = new TObjArray(577);

    for (Int_t i=0; i<577; i++)
        (*fArray)[i] = new MHFadcPix(i);
}

MHFadcCam::~MHFadcCam ()
{
    delete fArray;
}

/*void MHFadcCam::SaveHist(char *name)
{
    //
    //   save all histogram in this class to a root file
    //

    //
    // FIXME: Don't open a file and write to this file!
    // just Fill the current container (or the two histograms
    // to an open file. The user must choose a file before.
    //
    TFile out( name, "recreate") ;

    //
    //  loop over all pixels and write the files out
    //

    fHistLo->Write() ;
    fHistHi->Write() ;
}

  */