#ifndef MARS_MGEvtDisplay
#define MARS_MGEvtDisplay

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class TGTab;
class TList;
class TCanvas;
class TGLabel;
class TGTextEntry;

class MEvtLoop;
class MParList;
class MTaskList;
class MReadTree;

class MGEvtDisplay : public TGMainFrame/*TGTransientFrame*/
{
private:
    //
    // GUI stuff
    //
    TGLabel     *fNumOfEvts;
    TGLabel     *fEvtInfo;
    TGTextEntry *fTxtEvtNr;

    TGTab       *fEvtDisplay;

    void AddMenuBar();
    void AddTopFramePart1(TGVerticalFrame *frame,
                          const char *filename,
                          const char *treename);
    void AddTopFramePart2(TGVerticalFrame *frame);
    void AddMidFrame(TGHorizontalFrame *frame);
    void AddLowFrame(TGHorizontalFrame *frame);

    void AddFrames(const char *filename, const char *treename);

    void SaveAsDialog() const;
    void ReadinEvent();

    Bool_t fInitOk;

protected:
    TList     *fList;
    MEvtLoop  *fEvtLoop;

    TCanvas   *fCanvas;

    TGCompositeFrame *fTab1;
    TGCompositeFrame *fTab2;

    TGVerticalFrame  *fMidFrame;

    MParList  *GetParList() const;
    MTaskList *GetTaskList() const;
    MReadTree *GetReader() const;

    TCanvas *AddTab(TString name);

    void   ReadFirstEvent();
    Bool_t IsInitOk() { return fInitOk; }

    void UpdateMcLabel();

    virtual void UpdateDisplay() = 0;

public:
    MGEvtDisplay(const char *fname, const char *tname,
                 const TGWindow *p, /*const TGWindow *main,*/
                 UInt_t w, UInt_t h);

    ~MGEvtDisplay();

    void CloseWindow();

    virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

    ClassDef(MGEvtDisplay, 0) // base class to display something event by event
};

#endif


