#ifndef MGFADCDISP_H
#define MGFADCDISP_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class MParList ; 
class MRawRunHeader ; 
class MRawEvtHeader ; 
class MTime ; 
class MRawEvtData ; 
class MRawCrateArray ; 

class MReadTree ; 

class TGHorizontal3DLine;
class TGLabel ; 
class TGTextButton ; 
class TGTab ; 
class TGListBox ; 
class TGVSlider; 
class TRootEmbeddedCanvas ; 
class TCanvas ; 
class TGTextEntry ; 
class TGTextBuffer ; 

enum MGFadcDispCommand {
  
  M_PIXELLIST = 4201 , 
  M_PREVEVT, 
  M_NEXTEVT,
  M_EVTNUMBER, 

  M_PREVPIXEL, 
  M_NEXTPIXEL, 

  M_PRINT, 
  M_CLOSE 
  

}; 

//
//

class MGFadcDisp : public TGTransientFrame {

 private: 

  //
  //     members to read in the file
  //

  MParList       *pList ;
  MRawRunHeader  *fRunHeader ;
  MRawEvtHeader  *fEvtHeader ;
  MTime          *fEvtTime   ;
  MRawEvtData    *fEvtData    ;
  MRawCrateArray *fEvtCrate  ;

  MReadTree *fReadTree ;
  
  //
  //     members for the gui 
  // 
  
  //    divide the whole frame in three subframes
  
  TGVerticalFrame    *fFrameTop ; 
  TGHorizontalFrame  *fFrameMid, *fFrameLow ; 
  TGHorizontal3DLine *fLineSep1, *fLineSep2 ;

  //    members in the top frame

  TGHorizontalFrame  *fTop1, *fTop2 ; 
  TGLabel       *fLabelFile, *fNameFile,  *fLabelTree, *fNameTree ; 
  TGTextButton  *fButtonPrevEvt, *fButtonNextEvt ; 
  TGLabel       *fLabelEvtNr, *fLabelTotNr ; 
  TGTextEntry          *fTxtEvtNr ;
  TGTextBuffer         *fTxtBufEvtNr ; //!  no output for this member  
                                       //   neccessary to compile  H.K.

  //    members in the mid frame
  
  TGTab            *fTabControl ; 
  TGListBox        *fPixelList  ; 
  Int_t            fPixelsinList ; 
  TGVerticalFrame  *fMid1 ; 
  TGTextButton     *fButtonPrevPix, *fButtonNextPix ; 
  TGVSlider        *fPixSlider ; 
  
  TGTab   *fTabDisplay ; 
  TRootEmbeddedCanvas  *fECanDigScope ; 

  TCanvas               *fCan ;
  
  //    members in the low frame

  TGTextButton  *fButtonPrint, *fButtonClose ; 

 public:
  
  MGFadcDisp(char *filename, char *treename, 
	     const TGWindow *p, const TGWindow *main, UInt_t w, UInt_t h ) ; 

  ~MGFadcDisp()  ; 

  void CloseWindow() ; 

  void CreatePixelList() ; 
  void UpdateEventCounter() ; 
  void ReadinEvent(Int_t iEvt) ; 

  virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
 
  ClassDef(MGFadcDisp, 1)
}; 

#endif


