#ifndef MCAMGEOM_H
#define MCAMGEOM_H

#include <iostream>

#include "MAGIC.h"

class TObjArray ; 

class MPixGeom : public TObject
{ 
 private:
  Float_t  fX ;  //   the x coordinate 
  Float_t  fY ;  //   the y coordinate
  Float_t  fR ;  //   the y coordinate

 public:
  
  MPixGeom(Float_t x=0. , Float_t y=0., Float_t r=0.) ; 
  
  void Print() ; 
  
  void SetX ( Float_t x ) 
    {
      fX = x ; 
    }
  
  void SetY ( Float_t y ) 
    {
      fY = y ; 
    }
   
  void SetR ( Float_t r ) 
    {
      fR = r ; 
    }
  
  Float_t GetX() 
    { 
      return fX ; 
    } 
   
  Float_t GetY() 
    { 
      return fY ; 
    } 
  
  Float_t GetR()
    { 
      return fR ; 
    } 
  

  ClassDef(MPixGeom, 1)		// Geometric class for the pixel
} ; 


// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

class MCamGeom
{
 private: 
  Int_t         fNbPixels ;   // 
  TObjArray     *fPixels   ;  //!
  
  void CreateMagic() ; 
  void CreateCT1() ; 
  
 public:
  
  MCamGeom( Int_t type=0 ) ; 

  void Draw(Option_t *option = "" ) ; 
 
  Int_t    GetNbPixels() ; 
  Float_t  GetX(Int_t iPix ) ; 
  Float_t  GetY(Int_t iPix ) ; 
  Float_t  GetR(Int_t iPix ) ; 
  
  void Print() ; 

  

  ClassDef(MCamGeom, 1)		// Base (abstract) class for a task
};

#endif

