#ifndef MGEOMCAM_H
#define MGEOMCAM_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif
#ifndef MGEOMPIX_H
#include "MGeomPix.h"
#endif

class MGeomCam
{
private:
    Int_t          fNbPixels ;  //!
    TObjArray     *fPixels   ;  //!
  
    void CreateMagic() ;
    void CreateCT1() ;

public:

    MGeomCam( Int_t type=0 ) ;
    virtual ~MGeomCam() { delete fPixels; }

    void Draw(Option_t *option = "" ) ;

    Int_t    GetNbPixels() ;

    MGeomPix &operator[](Int_t i) { return *(MGeomPix*)fPixels->At(i); }

    void Print(Option_t *opt=NULL) ;

    ClassDef(MGeomCam, 1)		// Geometry class for the camera
};

#endif

