#ifndef MARS_MH3
#define MARS_MH3

#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef MARS_MH
#include "MH.h"
#endif

class TH1;
class TMethodCall;
class MDataChain;

class MH3 : public MH
{
private:
    static const TString gsDefName;
    static const TString gsDefTitle;

protected:
    // Could be const but root < 3.02/06 doesn't like this...
    Int_t       fDimension;      // Number of dimensions of histogram
    TH1        *fHist;           // Histogram to fill
    MDataChain *fData[3];        // Object from which the data is filled
    Double_t    fScale[3];       // Scale for the three axis (eg unit)

    void StreamPrimitive(ostream &out) const;

    enum {
        kIsLogx = BIT(17),
        kIsLogy = BIT(18),
        kIsLogz = BIT(19)
    };

public:
    MH3(const unsigned int dim=0);
    MH3(const TH1 &h1);
    MH3(const char *memberx);
    MH3(const char *memberx, const char *membery);
    MH3(const char *memberx, const char *membery, const char *memberz);
    ~MH3();

    // Setter
    void SetScaleX(Double_t scale) { fScale[0] = scale; }
    void SetScaleY(Double_t scale) { fScale[1] = scale; }
    void SetScaleZ(Double_t scale) { fScale[2] = scale; }

    void SetLogx(Bool_t b=kTRUE) { b ? fHist->SetBit(kIsLogx) : fHist->ResetBit(kIsLogx); }
    void SetLogy(Bool_t b=kTRUE) { b ? fHist->SetBit(kIsLogy) : fHist->ResetBit(kIsLogy); }
    void SetLogz(Bool_t b=kTRUE) { b ? fHist->SetBit(kIsLogz) : fHist->ResetBit(kIsLogz); }

    void Sumw2() const { if (fHist) fHist->Sumw2(); }

    // Getter
    Int_t GetDimension() const { return fDimension; }
    Int_t GetNbins() const;
    Int_t FindFixBin(Double_t x, Double_t y=0, Double_t z=0) const;

    TH1 &GetHist() { return *fHist; }
    const TH1 &GetHist() const { return *fHist; }

    TString GetDataMember() const;
    TString GetRule(const Char_t axis='x') const;

    // MH
    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TH1 *GetHistByName(const TString name="") const { return fHist; }
    TObject *FindObject(const TObject *obj) const { return 0; }
    TObject *FindObject(const char *name) const
    {
        return (TObject*)GetHistByName(name);
    }

    // MParContainer
    MParContainer *New() const;

    // TObject
    void SetName(const char *name);
    void SetTitle(const char *title);

    void SetColors() const;
    void Draw(Option_t *opt=NULL);
    void Paint(Option_t *opt="");

    ClassDef(MH3, 1) // Generalized 1/2/3D-histogram for Mars variables
};

#endif
