#ifndef MARS_MHHillasExt
#define MARS_MHHillasExt

#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef MARS_MHHillas
#include "MHHillas.h"
#endif

class MHHillasExt : public MHHillas
{
private:
    TH1F fHConc;    // [ratio] concentration ratio: sum of the two highest pixels / fSize
    TH1F fHConc1;   // [ratio] concentration ratio: sum of the highest pixel / fSize
    TH1F fHAsym;    // [mm]    fDist minus dist: center of ellipse, highest pixel
    TH1F fHM3Long;  // [mm]    3rd moment (e-weighted) along major axis
    TH1F fHM3Trans; // [mm]    3rd moment (e-weighted) along minor axis

public:
    MHHillasExt(const char *name=NULL, const char *title=NULL);
    ~MHHillasExt();

    void SetMmScale(Bool_t mmscale=kTRUE);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MHHillasExt, 1) // Container which holds histograms for length and width
};

#endif
