#ifndef MARS_MHHadroness
#define MARS_MHHadroness

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1D;
class TGraph;
class MParList;
class MMcEvt;
class MHadroness;

class MHHadroness : public MH
{
private:
    const MMcEvt *fMcEvt;            //!
    const MHadroness *fHadroness;    //!

    TH1D* fPhness;        // Hadrons Hadroness
    TH1D* fGhness;        // Gammas Hadroness
    TH1D* fIntPhness;     // Hadrons Acceptance
    TH1D* fIntGhness;     // Gammas Acceptance
    TH1D* fQfac;          // Quality factor
    TH1D* fMinDist;       // Minimum Distance to optimum acceptance

    TGraph *fGraph;       // gamma acceptance vs. hadron acceptance

public:
    MHHadroness(Int_t nbins=100, const char *name=NULL, const char *title=NULL);
    ~MHHadroness();

    Double_t GetGammaAcceptance(Double_t acchad) const;

    TH1D *GetQfac() const    { return fQfac; }
    TH1D *Getghness() const  { return fGhness; }
    TH1D *Getphness() const  { return fPhness; }
    TH1D *Getighness() const { return fIntGhness; }
    TH1D *Getiphness() const { return fIntPhness; }
    //TH2D *GetHist() const    { return fHist; }

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par);
    Bool_t Finalize();

    void Print(Option_t *option="") const;

    void Draw(Option_t *opt="");
    TObject *DrawClone(Option_t *opt="") const;

    ClassDef(MHHadroness, 1) // Gamma/Hadron Separation Quality Histograms
};

#endif
