#ifndef MARS_MH
#define MARS_MH

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TH1;
class TH2;
class TH3;
class TAxis;
class TArrayD;
class TCanvas;

class MBinning;
class MParList;

class MH : public MParContainer
{
public:
    MH(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList) { return kTRUE; }
    virtual Bool_t Fill(const MParContainer *par);
    virtual Bool_t Finalize() { return kTRUE; }

    static TCanvas *MakeDefCanvas(TString name="", const char *title="",
                                  const UInt_t w=580, const UInt_t h=435);
    static TCanvas *MakeDefCanvas(const TObject *obj,
                                  const UInt_t w=580, const UInt_t h=435);

    static void SetBinning(TH1 *h, const MBinning *binsx);
    static void SetBinning(TH2 *h, const MBinning *binsx, const MBinning *binsy);
    static void SetBinning(TH3 *h, const MBinning *binsx, const MBinning *binsy, const MBinning *binsz);

    static void SetBinning(TH1 *h, const TArrayD &binsx);
    static void SetBinning(TH2 *h, const TArrayD &binsx, const TArrayD &binsy);
    static void SetBinning(TH3 *h, const TArrayD &binsx, const TArrayD &binsy, const TArrayD &binsz);

    static void SetBinning(TH1 *h, const TAxis *binsx);
    static void SetBinning(TH2 *h, const TAxis *binsx, const TAxis *binsy);
    static void SetBinning(TH3 *h, const TAxis *binsx, const TAxis *binsy, const TAxis *binsz);

    static void SetBinning(TH1 *h, TH1 *x);

    static Bool_t ApplyBinning(const MParList &plist, TString name, TH1 *h);

    static void    ScaleArray(TArrayD &bins, Double_t f);
    static TArrayD ScaleAxis(TAxis &axe, Double_t f);
    static void    ScaleAxis(TH1 *bins, Double_t fx=1, Double_t fy=1, Double_t fz=1);

    static void DrawCopy(const TH1 &hist1, const TH1 &hist2, const TString title);
    static void Draw(TH1 &hist1, TH1 &hist2, const TString title);

    static void FindGoodLimits(Int_t nbins, Int_t &newbins, Double_t &xmin, Double_t &xmax, Bool_t isInteger);
    static Double_t GetMinimumGT(const TH1 &h, Double_t gt=0);

    ClassDef(MH, 1) //A histogram base class for Mars histograms
};

#endif

