#ifndef MARS_MHFlux
#define MARS_MHFlux

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TH1
#include "TH1.h"
#endif

#ifndef ROOT_TH2
#include "TH2.h"
#endif

class TH2D;

// base class MH is used because it defines "MakeDefCanvas"
// if base class MH is used one has to define the member function Fill
//                          because in MH Fill is set to zero
class MHFlux : public MH 
{
private:

    TString fVarname;
    TString fUnit;

    TH2D fHOrig;       // original distribution of E-est 
    TH2D fHUnfold;     // unfolded distribution of E-unfold
    TH2D fHFlux;       // absolute differential photon flux versus E-unfold
    // all these plots for different bins of the variable (Theta or time)

public:
    MHFlux(const TH2D &h2d, const Bool_t Draw,
	   const TString varname, const TString unit);

    Bool_t Fill(const MParContainer *par);

    void Unfold(const Bool_t Draw);
    void CalcFlux(const TH1D *teff, const TProfile *thetabar,
                  const TH2D *aeff, const Bool_t Draw);

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    const TH2D *GetHOrig()       { return &fHOrig; }
    const TH2D *GetHUnfold()     { return &fHUnfold; }
    const TH2D *GetHFlux()       { return &fHFlux; }

    static Bool_t Parab(double x1, double x2, double x3,
                        double y1, double y2, double y3,
                        double *a, double *b, double *c);

    ClassDef(MHFlux, 1) //2D-plots (original, unfolded, flux)
};

#endif












