#ifndef MARS_MHEnergyTime
#define MARS_MHEnergyTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MTime;
class MParList;

class MHEnergyTime : public MH
{
private:
    MTime *fTime;
    TH2D fHist; //! 

public:

    MHEnergyTime(const char *name=NULL, const char *title=NULL);
    ~MHEnergyTime();

    Bool_t Fill(const MParContainer *cont);

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    Bool_t SetupFill(const MParList *plist);

    const TH2D *GetHist() { return &fHist; }
    const TH2D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Divide(const TH2D *h1, const TH2D *h2);
    void Divide(const MHEnergyTime *h1, const MHEnergyTime *h2)
    {
        Divide(h1->GetHist(), h2->GetHist());
    }

    ClassDef(MHEnergyTime, 1)  // Histogram: Energy vs. Time
};

#endif
