/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Wolfgang Wittek 1/2002 <mailto:wittek@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  MHThetabarTheta                                                         //
//                                                                          //
//  calculates the average Theta for different bins in Theta                //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "MHThetabarTheta.h"

#include <TCanvas.h>

#include "MMcEvt.hxx"

#include "MBinning.h"
#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MHThetabarTheta);

// --------------------------------------------------------------------------
//
// Default Constructor. It sets name and title of the histogram.
//
MHThetabarTheta::MHThetabarTheta(const char *name, const char *title)
    : fHist()
{
    //
    //   set the name and title of this object
    //
    fName  = name  ? name  : "MHThetabarTheta";
    fTitle = title ? title : "1-D profile histogram Thetabar vs. Theta";

    fHist.SetDirectory(NULL);

    fHist.SetXTitle("\\Theta [\\circ]");
    fHist.SetYTitle("Theta-bar [ \\circ]");
}

// --------------------------------------------------------------------------
//
// Set the binnings and prepare the filling of the histogram
//
Bool_t MHThetabarTheta::SetupFill(const MParList *plist)
{
    fMcEvt = (MMcEvt*)plist->FindObject("MMcEvt");
    if (!fMcEvt)
    {
        *fLog << err << dbginf << "MMcEvt not found... aborting." << endl;
        return kFALSE;
    }

    const MBinning* binstheta = (MBinning*)plist->FindObject("BinningTheta");
    if (!binstheta )
    {
        *fLog << err << dbginf << "At least one MBinning not found... aborting." << endl;
        return kFALSE;
    }

    SetBinning(&fHist, binstheta);

    return kTRUE;
}

// --------------------------------------------------------------------------
//
// Draw a copy of the histogram
//
TObject *MHThetabarTheta::DrawClone(Option_t *opt) const
{
    TCanvas &c = *MakeDefCanvas("ThetabarTheta", "Thetabar vs. Theta");

    gROOT->SetSelectedPad(NULL);

    ((TProfile)fHist).DrawCopy(opt);

    c.Modified();
    c.Update();

    return &c;
}

// --------------------------------------------------------------------------
//
// Draw the histogram
//
void MHThetabarTheta::Draw(Option_t *opt)
{
    if (!gPad)
        MakeDefCanvas("ThetabarTheta", "Thetabar vs. Theta");

    fHist.DrawCopy(opt);

    gPad->Modified();
    gPad->Update();
}

// --------------------------------------------------------------------------
//
// Fill the histogram
//
Bool_t MHThetabarTheta::Fill(const MParContainer *par)
{
    const Double_t theta = fMcEvt->GetTelescopeTheta()*kRad2Deg;

    fHist.Fill(theta, theta);

    return kTRUE;
}
