#ifndef MARS_MHEffectiveOnTime
#define MARS_MHEffectiveOnTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef ROOT_TH2
#include <TH2.h>
#endif

class MTime;
class MPointingPos;
class MParameterDerr;

class MParList;

class MHEffectiveOnTime : public MH
{
private:
    MPointingPos   *fPointPos;   //!
    MTime           fLastTime;   //!

    MTime          *fTime;       //!
    MParameterDerr *fParam;      //!

    TH2D fH2DeltaT;              // Counts vs Delta T and Theta
    TH1D fH1DeltaT;              //! Counts vs Delta T (for a time interval)

    TH1D fHEffOnTheta;           // Effective On time versus Theta
    TH1D fHEffOnTime;            // Effective On time versus Time

    TH1D fHProbTheta;            // Chisq prob fit of Effective On time versus Theta
    TH1D fHProbTime;             // Chisq prob fit of Effective On time versus Time

    TH1D fHN0;
    TH1D fHLambda;

    Bool_t fIsFinalized;

    Int_t fNumEvents;

    const TString fNameProjDeltaT;  //! This should make sure, that gROOT doen't confuse the projection with something else
    const TString fNameProjTheta;   //! This should make sure, that gROOT doen't confuse the projection with something else

    Bool_t FitH(TH1D *h, Double_t *res, Bool_t paint=kFALSE) const;
    void FitThetaBins();
    void FitTimeBin();
    void PaintText(Double_t val, Double_t error) const;

public:
    MHEffectiveOnTime(const char *name=NULL, const char *title=NULL);

    void SetNumEvents(Int_t i) { fNumEvents=i; }

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    void Draw(Option_t *option="");
    void Paint(Option_t *opt="");

    ClassDef(MHEffectiveOnTime, 1) // 2D-histogram to determin effective on-time vs. theta
};

#endif

