#ifndef MHMCENERGY_H
#define MHMCENERGY_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class TH1F;
class TF1;

class MHMcEnergy : public MParContainer
{
private:

    TH1F *fHist;  // histogram with the logarith of the energy

    Float_t fThreshold;
    Float_t fThresholdErr;
    Float_t fGaussPeak;
    Float_t fGaussSigma;

    Float_t CalcThreshold(TF1 *gauss);
    Float_t CalcThresholdErr(TF1 *gauss);

    Float_t CalcGaussPeak(TF1 *gauss);
    Float_t CalcGaussSigma(TF1 *gauss);

public:

    MHMcEnergy(const char *name=NULL, const char *title=NULL);
    ~MHMcEnergy();

    void SetName(const char *name);

    Float_t GetThreshold() const { return fThreshold; }
    Float_t GetThresholdErr() const { return fThresholdErr; }

    Float_t GetGaussPeak() const { return fGaussPeak; }
    Float_t GetGaussSigma() const { return fGaussSigma; };

    void Fill(Float_t log10E, Float_t w);
    void Fit(Axis_t xxmin, Axis_t xxmax);
    void SetNumBins(Int_t nbins = 100);

    void Draw(Option_t* option = "");
    void Print(Option_t* option = NULL);

    ClassDef(MHMcEnergy, 1)  // Histogram container for montecarlo energy threshold
};

#endif
