#ifndef MARS_MNewImagePar
#define MARS_MNewImagePar

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MHillas;
class MGeomCam;
class MCerPhotEvt;

class MNewImagePar : public MParContainer
{
private:
    Float_t fLeakage1;      // (photons in most outer ring of pixels) over fSize
    Float_t fLeakage2;      // (photons in the 2 outer rings of pixels) over fSize

    Float_t fConc;          // [ratio] concentration ratio: sum of the two highest pixels / fSize
    Float_t fConc1;         // [ratio] concentration ratio: sum of the highest pixel / fSize

    Short_t fNumUsedPixels; // Number of pixels which survived the image cleaning
    Short_t fNumCorePixels; // number of core pixels

    Short_t fNumSaturatedPixels; // number of saturated pixels

public:
    MNewImagePar(const char *name=NULL, const char *title=NULL);

    void Reset();

    Float_t GetLeakage1() const    { return fLeakage1; }
    Float_t GetLeakage2() const    { return fLeakage2; }

    Float_t GetConc() const        { return fConc; }
    Float_t GetConc1() const       { return fConc1; }

    Int_t GetNumUsedPixels() const { return fNumUsedPixels; }
    Int_t GetNumCorePixels() const { return fNumCorePixels; }

    Short_t GetNumSaturatedPixels() const { return fNumSaturatedPixels; }

    void Print(Option_t *opt=NULL) const;

    void Calc(const MGeomCam &geom, const MCerPhotEvt &evt,
              const MHillas &hillas);

    ClassDef(MNewImagePar, 2) // Container to hold new image parameters
};

#endif



























